﻿/*	VERSION:  1.5

USAGE:
	#include "functions/resolveContainer.as"
	container_ref = resolveContainer("RAM");
	
DESCRIPTION:
	Returns a reference to a global ar local container, based on its name.
	ALT
	Validates a container string and returns it if it's valid.
*/
resolveContainer = function( containerName, thisRef )
{
	var thisRef = (thisRef) ? thisRef : this;
	var output = _global[containerName];
	
	if(containerName == "this")
		output = thisRef;
	if(containerName == "_root")
		output = _root;
	if(containerName == "_level0")
		output = _root;
	if(containerName == "_global")
		output = _global;
	
	return output;
}// resolveContainer()



resolveContainerStr = function( containerName, thisName )
{
	var thisName = (thisName) ? thisName : "this";
	var output = null;
	
	if(containerName == "this")
		output = thisName;
	if(containerName == "_root")
		output = "_root";
	if(containerName == "_level0")
		output = "_root";
	if(containerName == "_global")
		output = "_global";
	if(_global[containerName])
		output = containerName;
	
	return output;
}// resolveContainer()